<?php
   /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../../../include/util.php";
    include "../../../../include/costanti.php";
    include "../../../../gUtil/DbManager.php";
    include "../classi/ProdottiDalNegozio.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    session_start();
    controlloAccessoAdmin();
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $occorrenza = new ProdottiDalNegozio($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $occorrenza = new ProdottiDalNegozio($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $occorrenza->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_STRING));
            $occorrenza->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $occorrenza->setEtichettaPulsanteAltriProdotti(filter_input(INPUT_POST,"etichettaPulsanteAltriProdotti"));
            $occorrenza->setLinkPulsanteAltriProdotti(filter_input(INPUT_POST,"linkPulsanteAltriProdotti",FILTER_SANITIZE_STRING));
            $occorrenza->setNumeroProdotti(filter_input(INPUT_POST,"numeroProdotti",FILTER_SANITIZE_NUMBER_INT));
            $occorrenza->setDimensioneDivSingoloProdotto(filter_input(INPUT_POST,"dimensioneDivSingoloProdotto",FILTER_SANITIZE_STRING));
            $occorrenza->setTipoVisualizzazione(filter_input(INPUT_POST,"tipoVisualizzazione",FILTER_SANITIZE_STRING));
            $occorrenza->setTipoProdotti(filter_input(INPUT_POST,"tipoProdotti",FILTER_SANITIZE_STRING));
            $occorrenza->setAspetto(filter_input(INPUT_POST,"aspetto",FILTER_SANITIZE_STRING));
            $occorrenza->setCategoria(filter_input(INPUT_POST,"categoria",FILTER_SANITIZE_NUMBER_INT));
            $occorrenza->setCategorieIndicate(filter_input(INPUT_POST,"categorieIndicate",FILTER_SANITIZE_STRING));
            $occorrenza->setEscludiCategoria(filter_input(INPUT_POST,"escludiCategoria"));
            $occorrenza->setLingua(filter_input(INPUT_POST,"lingua",FILTER_SANITIZE_STRING));
            $occorrenza->setMostraTitoloComponente(filter_input(INPUT_POST,"mostraTitoloComponente"));
            $occorrenza->setMostraPrezzo(filter_input(INPUT_POST,"mostraPrezzo",FILTER_SANITIZE_STRING));
            $occorrenza->setEscludiProdottiEsauriti(filter_input(INPUT_POST,"escludiProdottiEsauriti",FILTER_SANITIZE_STRING));
            $occorrenza->setMarca(filter_input(INPUT_POST,"marca",FILTER_SANITIZE_STRING));
            $occorrenza->setEscludiMarca(filter_input(INPUT_POST,"escludiMarca",FILTER_SANITIZE_STRING));
            $occorrenza->crea();
            header("Location: ../creaProdottiDalNegozio.php?id={$occorrenza->getId()}&status=200");
            break;
        case 'modifica':
            $occorrenza->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_STRING));
            $occorrenza->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $occorrenza->setEtichettaPulsanteAltriProdotti(filter_input(INPUT_POST,"etichettaPulsanteAltriProdotti"));
            $occorrenza->setLinkPulsanteAltriProdotti(filter_input(INPUT_POST,"linkPulsanteAltriProdotti",FILTER_SANITIZE_STRING));
            $occorrenza->setNumeroProdotti(filter_input(INPUT_POST,"numeroProdotti",FILTER_SANITIZE_NUMBER_INT));
            $occorrenza->setDimensioneDivSingoloProdotto(filter_input(INPUT_POST,"dimensioneDivSingoloProdotto",FILTER_SANITIZE_STRING));
            $occorrenza->setTipoVisualizzazione(filter_input(INPUT_POST,"tipoVisualizzazione",FILTER_SANITIZE_STRING));
            $occorrenza->setTipoProdotti(filter_input(INPUT_POST,"tipoProdotti",FILTER_SANITIZE_STRING));
            $occorrenza->setAspetto(filter_input(INPUT_POST,"aspetto",FILTER_SANITIZE_STRING));
            $occorrenza->setCategoria(filter_input(INPUT_POST,"categoria",FILTER_SANITIZE_NUMBER_INT));
            $occorrenza->setCategorieIndicate(filter_input(INPUT_POST,"categorieIndicate",FILTER_SANITIZE_STRING));
            $occorrenza->setEscludiCategoria(filter_input(INPUT_POST,"escludiCategoria"));
            $occorrenza->setLingua(filter_input(INPUT_POST,"lingua",FILTER_SANITIZE_STRING));
            $occorrenza->setMostraTitoloComponente(filter_input(INPUT_POST,"mostraTitoloComponente"));
            $occorrenza->setMostraPrezzo(filter_input(INPUT_POST,"mostraPrezzo",FILTER_SANITIZE_STRING));
            $occorrenza->setEscludiProdottiEsauriti(filter_input(INPUT_POST,"escludiProdottiEsauriti",FILTER_SANITIZE_STRING));
            $occorrenza->setMarca(filter_input(INPUT_POST,"marca",FILTER_SANITIZE_STRING));
            $occorrenza->setEscludiMarca(filter_input(INPUT_POST,"escludiMarca",FILTER_SANITIZE_STRING));
            $occorrenza->modifica();
            header("Location: ../creaProdottiDalNegozio.php?id={$occorrenza->getId()}&status=250");
            break;
        case 'elimina':
            $occorrenza->elimina();
            echo "ok";
            break;
        case 'duplica':
            $occorrenza->caricaDatiDalDatabase();
            $idNuovaForm = $occorrenza->duplica();
            header("Location: ../creaProdottiDalNegozio.php?id={$idNuovaForm}&status=260");
            break;
    }
